
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Jan 12 12:17:37 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_Ext_ATP_ECC_Acceptance_test_vectors.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
   
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */   
   
/*****************************************************************************
 * File Name:                                                           
 *  CRYS_ATP_TST_ECC_Acceptance_test_vectors.c      
 *
 * Description:                                                                 
 *  This file contatind the test vectors used for RCA Acceptance tests                              
 *
 ******************************************************************************/

/************* Include Files ****************/
#include "CRYS_error.h"
#include "CRYS_Ext_ATP_ECC_Acceptance.h"

/************************ Defines **********************************/
/************************ Enums ************************************/
/************************ Typedefs *********************************/
/************************ Global Data ******************************/
/************* Private function prototype **************************/
/************************ Public Functions *************************/
/************************ Private Functions ************************/

/********************************/
/*  ECDSA SignVerify test data  */
/********************************/

TST_ExtApp_ECC_SignVerifyTestDataStruct SEP_ECC_Acceptance_ECDSA_SignVerify_TestData[] =
{
	{
        {"Acceptance test - ECDSA_SignVerify - secp521r-Key - 512byte data "},
         /*TST_CRYS_ECPKI_DomainID*/
         CRYS_ECPKI_DomainID_secp521r1,
         /*CRYS_ECPKI_HASH_OpMode_t*/
         CRYS_ECPKI_HASH_SHA1_mode,
         /*TST_input_data*/
        {0xf4,0xd0,0x05,0x79,0x91,0xdd,0x6e,0xca,0x3c,0x42,0x50,0x38,0xf7,0x47,0xdd,0x00,
         0x97,0xc0,0xa8,0x35,0x74,0xf0,0xfe,0xc0,0x65,0xa8,0x7a,0xa6,0xec,0xaf,0xd4,0x89,
         0xad,0x66,0xfa,0x72,0x25,0xac,0x62,0xcd,0x98,0x00,0x9e,0xb5,0x4b,0xe5,0x31,0x72,
         0xf4,0x8b,0xa1,0x40,0x6f,0xab,0xcd,0x52,0xb2,0xb3,0x81,0x17,0x03,0x23,0x48,0xbc,
         0x69,0x37,0x81,0xf2,0x60,0xc6,0xb5,0xf1,0xd0,0x6a,0x28,0xbd,0x40,0xe1,0xae,0xa8,
         0x47,0xb3,0xc0,0x18,0x44,0x15,0xcf,0x8a,0x4f,0x0e,0xd8,0xd7,0x70,0xd8,0x39,0xb6,
         0x0e,0x89,0xc3,0x83,0xaa,0xf3,0x10,0x3f,0xcd,0xc8,0x17,0xd7,0x3e,0x02,0xfd,0xa9,
         0x79,0x81,0x2f,0x44,0x5d,0xf6,0xad,0x6f,0x25,0x01,0xa9,0x6e,0x99,0x96,0x50,0x80,
         0x85,0xa5,0xe8,0xac,0x6b,0xfa,0x1b,0xbd,0x75,0x62,0x92,0x8c,0xad,0x0f,0xc6,0x7d,
         0x70,0x3d,0x13,0x4c,0x20,0x16,0x0f,0x0a,0x1a,0xd3,0x19,0x62,0xe8,0x25,0x35,0x21,
         0xb7,0xd3,0x17,0xf6,0x0b,0xa4,0x7d,0x75,0xb1,0x7f,0xc2,0x62,0xf6,0xd1,0xb0,0x2d,
         0x16,0x2f,0x97,0xb9,0xf7,0x3d,0x9b,0x61,0x17,0xce,0x52,0x3d,0xc3,0x4c,0x8f,0xa1,
         0x8b,0x5b,0x78,0xe7,0xf2,0xb9,0xdf,0x6f,0x6a,0x68,0xcf,0xe3,0x7f,0x10,0x64,0xc0,
         0x52,0x9f,0xe0,0x12,0x49,0x32,0xfc,0x7f,0x05,0x38,0x7c,0x86,0x94,0xd4,0x06,0x09,
         0xe8,0x84,0x34,0x09,0x88,0x01,0xe8,0xb2,0x86,0x66,0xe0,0x97,0xb1,0x93,0x8a,0x3e,
         0x0b,0xd4,0x19,0xdf,0x7e,0xbe,0xd8,0x69,0xca,0x5a,0xbe,0xc6,0xc2,0x86,0x43,0x60,
         0xb8,0x97,0x73,0xe4,0x36,0x43,0x41,0x46,0xef,0xbf,0x1d,0x05,0xf4,0x24,0xc9,0xb0,
         0x2b,0x17,0x68,0xa9,0xfe,0xa9,0xd8,0x29,0x50,0x7c,0x41,0x84,0xb5,0x28,0xee,0xae,
         0xe2,0xdc,0x5c,0xfe,0x62,0x49,0x91,0x33,0x8b,0xbb,0xaf,0xb5,0xb1,0x89,0xc9,0x1d,
         0x99,0xb0,0xf5,0xf6,0x30,0xbb,0xa3,0xc5,0x7d,0xe6,0x2d,0x48,0xd5,0x82,0xaf,0xfc,
         0x4e,0x9b,0x18,0xe1,0x76,0xd9,0x81,0x81,0x44,0xa4,0xbe,0x2f,0x4e,0x8b,0x33,0x8d,
         0x3d,0xe7,0xe9,0x51,0x7e,0xbb,0xe2,0x48,0x3b,0xdf,0xa9,0x9b,0x8a,0x5e,0x2c,0x51,
         0xe4,0x1c,0xce,0x15,0xd8,0xbc,0xb9,0x39,0x00,0xc0,0x71,0xfc,0x35,0xf2,0xaf,0x08,
         0xff,0x03,0x6c,0x3f,0x4f,0x73,0x3c,0xb7,0x71,0xb0,0xdd,0x03,0x3c,0x82,0x10,0xb5,
         0x8c,0xa6,0xa7,0x20,0xf2,0xba,0xe0,0x63,0xa9,0x59,0xf1,0xa3,0xcc,0x86,0xe4,0x97,
         0xc7,0x4e,0xa5,0x4a,0x0c,0xa9,0x5a,0x1c,0x07,0xa2,0xf2,0x0a,0x53,0xb7,0x01,0x30,
         0x2e,0x83,0xcb,0x8c,0x2a,0x9a,0x9e,0x05,0x26,0xb5,0x66,0xac,0x7d,0x0f,0x7b,0x41,
         0x7d,0x0e,0xbd,0xf9,0x1b,0x26,0xe3,0x7e,0xe4,0xfb,0x10,0x38,0x37,0xc5,0xa7,0xcb,
         0xb2,0xf9,0x61,0xe1,0xea,0x26,0x9d,0x29,0x5f,0x1c,0xf7,0xa0,0xaf,0x54,0x1b,0x0f,
         0x09,0x8c,0xdc,0xd4,0xe5,0xb2,0x80,0xe6,0xf2,0x03,0x5e,0x14,0x50,0x74,0xac,0x8d,
         0x00,0x51,0x92,0xa5,0x99,0x24,0x82,0xd6,0x3c,0xd8,0xcc,0x05,0xc9,0x1e,0x6d,0x07,
         0x53,0x10,0x28,0x64,0xd2,0x14,0xd9,0x5b,0x18,0x04,0x05,0x26,0x07,0x8c,0xb5,0x7f},
         /*TST_input_dataSize*/
         512, 
         /*TST_ExternalPublKey*/
        {0x04,
         0x00,0xa5,0x1b,0x2f,0x69,0x01,0xd0,0xbc,0xf3,0x31,0xc3,0x6b,0xfe,0xd2,0x1c,0x10,
         0x0e,0x06,0x65,0x4c,0xfe,0xeb,0x79,0x26,0x32,0x27,0xae,0x52,0x7c,0x0f,0x2d,0x5e,
         0x61,0x63,0xde,0x43,0x11,0xdd,0xae,0x04,0xb8,0xa3,0x8b,0x86,0x02,0x49,0x6a,0xa5,
         0xa0,0x29,0x3a,0x39,0xd5,0xd1,0xd9,0x66,0xe4,0xd9,0xcc,0x1b,0xc7,0x72,0xa1,0x85,
         0xd1,0x1e,0x00,0x7c,0x58,0x83,0x1b,0x20,0xb6,0xdc,0xd4,0xed,0x7d,0x5c,0x57,0x02,
         0xaa,0x48,0xb2,0xd4,0xf8,0x8c,0x22,0xdf,0x66,0xe4,0x21,0x92,0x45,0x7c,0xe5,0x77,
         0x04,0x26,0xb8,0xf1,0x49,0xa4,0x03,0x23,0x7c,0xe5,0xd7,0x4e,0xbf,0xc4,0x8b,0xee,
         0xd0,0xfa,0xba,0xf3,0x02,0xb8,0xb8,0x33,0x80,0x70,0x37,0xa0,0xfb,0x7b,0xd9,0x19,
         0x4d,0xfd,0xc9,0xd0},
        /*TST_ExternalPublKeySize*/
        133,
        /*TST_ExternalPrivKey*/
        {0xf0,0xac,0xa4,0x26,0x28,0x52,0x83,0xa6,0x8c,0xc3,0x4f,0xe7,0xd8,0x62,0xc6,0x2a,
         0xcb,0x33,0xd1,0x4c,0x34,0x0a,0x7d,0xb9,0xa8,0x9b,0x4d,0x6f,0xa0,0xfa,0xb6,0x38,
         0x77,0x75,0xfd,0xb4,0x4c,0xf5,0xb8,0x52,0x7b,0x1f,0x85,0x13,0xc6,0x78,0xae,0xa7,
         0x6f,0x1a,0xd4,0x08,0xdc,0xa2,0xbb,0x9a,0x02,0x78,0x34,0xd4,0x54,0x21,0x03,0x30,
         0x71},
        /*TST_ExternalPrivlKeySize*/
        65,
        /*TST_output_signiture*/
        {0},
        /*TST_SignitureSize*/
        132,
    }
};


/**********************/
/*  ECC DH test data  */
/**********************/

TST_ExtApp_ECC_DH_TestDataStruct  SEP_ECC_Acceptance_DH_TestData[] =
{
    { 
        {"Acceptance test - ECC-DH DomainID_secp521r1"},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp521r1,
        /*TST_ExternalPublKey1*/
        {0x04,
         0x01,0x97,0xb8,0x6b,0x1b,0x7d,0xa3,0xb9,0x44,0x51,0xa2,0xfc,0x6c,0x77,0xae,0x65,
         0x24,0xfd,0x3d,0xdb,0xa9,0x43,0x4f,0x79,0x66,0x5a,0xb1,0x4c,0x8e,0xa9,0xb3,0x88,
         0x6f,0xf3,0x5a,0x96,0xb4,0x92,0xb4,0xa2,0x06,0xbf,0x19,0x52,0x87,0x7a,0xff,0xff,
         0x31,0xe3,0x4e,0x10,0x2b,0x19,0x35,0x16,0x28,0xb6,0xd5,0x19,0xc9,0x7c,0x3d,0xf8,
         0x86,0x22,0x00,0x5e,0x40,0x8b,0x7c,0xe0,0xc3,0x26,0xea,0x94,0x2b,0xbe,0x79,0xe6,0x22,
         0x1e,0x9a,0x5b,0x62,0x97,0xc6,0xa2,0x69,0xab,0xd1,0x1e,0xe3,0xd2,0xc2,0x4e,0x4a,
         0x1a,0xc3,0xa3,0x74,0x12,0x0f,0x5c,0x32,0x05,0xae,0x10,0x6a,0xb7,0xe2,0x76,0x09,
         0xdd,0x69,0xd0,0x99,0xd7,0x2f,0x85,0xd5,0x9f,0x41,0x31,0x1c,0xa2,0x70,0x3a,0xa8,
         0x21,0xa7,0x6a},
        /*TST_ExternalPublKey1Size*/
        133,
        /*TST_ExternalPrivKey1*/
        {0x49,0xe4,0xed,0x27,0xdc,0x7a,0x6c,0x55,0xa3,0xb5,0xc4,0x12,0x51,0xdb,0x4d,0x21,
         0xd8,0x7d,0x69,0x6e,0xc6,0xc3,0xd4,0x2a,0xfc,0xf6,0xc8,0x1f,0xbe,0x46,0x99,0x2d,
         0x91,0x37,0x7b,0x7e,0xef,0x25,0x28,0xf4,0x35,0x84,0x9e,0xfb,0x7b,0x0e,0x44,0x0d,
         0x52,0x9b,0x8b,0x2f,0x9f,0xc5,0x01,0x40,0xc3,0xf6,0x2f,0x8b,0xa8,0x64,0xfa,0x47,
         0x0e},
        /*TST_ExternalPrivKey1Size*/
        65,
        /*TST_ExternalPublKey2*/
        {0x04,
         0x00,0xee,0x77,0xf4,0x37,0x72,0x1e,0x0d,0xf3,0x5d,0x20,0xb1,0xe5,0xbe,0xb9,0x1f,
         0x86,0xb1,0x82,0x93,0x20,0x20,0x2d,0x5d,0x6a,0x7b,0x7a,0x36,0x19,0xe8,0xf3,0xba,
         0x30,0xc8,0x45,0x76,0x03,0xf7,0xa0,0xa9,0x26,0x36,0x85,0x9c,0x0f,0xee,0x99,0xfb,
         0x32,0xbc,0xdd,0x13,0xf5,0xdc,0x53,0xa9,0x16,0x81,0x69,0xff,0x9c,0xc4,0x39,0x79,
         0xd2,0x19,0x00,0x4f,0xce,0x2f,0xd3,0x4f,0xf5,0x08,0x92,0x5a,0x95,0x15,0x9a,0x57,0x35,
         0x54,0x96,0x50,0xc5,0xcd,0x79,0xcd,0x3c,0x7d,0x6b,0x38,0x8c,0x66,0x66,0x82,0x3a,
         0xb2,0xdb,0xb6,0xa5,0x87,0x29,0x4a,0x78,0xaa,0x92,0x30,0x1e,0x8c,0x72,0x7a,0xab,
         0xc1,0x6e,0xad,0x24,0x38,0x5c,0x1c,0xda,0x6e,0x82,0x8a,0x59,0x13,0x84,0xb4,0xe4,
         0xbe,0xa5,0x37},
        /*TST_ExternalPublKey2Size*/
        133,
        /*TST_ExternalPrivKey2*/
        {0x2e,0x22,0x9b,0x00,0xdd,0x11,0x7b,0x07,0x75,0xc0,0x86,0xa9,0xe2,0xa2,0x04,0xb4,
         0x31,0x14,0x22,0x2c,0x70,0xf3,0x7e,0xed,0x18,0xd4,0xc0,0xe6,0xde,0x60,0x3f,0xbc,
         0xba,0xdb,0x49,0x1c,0xc7,0x01,0x87,0x46,0x33,0xa0,0x9a,0x31,0x4a,0x11,0xfd,0xb6,
         0x87,0x6d,0x97,0x5c,0x23,0xea,0xbf,0xc4,0xe7,0xf7,0x13,0x98,0xb7,0xd5,0x56,0xc5,
         0x74},
        /*TST_ExternalPrivKey2Size*/
        65,
    }
	
};
/***************************************/
/*  ElGamal Encrypt Decrypt test data  */
/***************************************/
TST_ExtApp_ECC_EncDecTestDataStruct SEP_ECC_Acceptance_ElGamal_EncDec_TestData[] =
{
	{ 
       {"Acceptance test - ElGamal EncryptDecrypt WMDRM-Key - 23byte data "},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_WMDRM10,
        /*TST_input_data*/
        {0xec,0xca,0x8d,0x21,0xfa,0x20,0x4d,0xdc,0x1b,0x04,0x07,0xb9,0xa6,0x46,0xdd,0xa3,
		0xe3,0xd9,0x85},
        /*TST_input_dataSize*/
        19, 
         /*TST_ExternalPublKey*/
        {0x36,0x41,0x4F,0xE7,0xDD,0x87,0x39,0x84,0x30,0x13,0x99,0xF4,0x83,0xD6,0xA1,0x79,0xE0,0xD2,0x2C,0xED,0x6D, 
		0x2D,0xB,0x5A,0x23,0x81,0x36,0xD5,0xCD,0x58,0x15,0x26,0x4F,0x8D,0xCA,0x8,0x40,0x92,0x80,0x33},
        /*TST_ExternalPublKeySize*/
        40,
        /*TST_ExternalPrivKey*/
        {0x63,0x8D,0x7E,0xAC,0x1A,0x10,0x9D,0x7,0x47,0x8D,0x8C,0xB8,0xE6,0x69,0x8,0x5E,0x94,0x52,0xA0,0x4b},
        /*TST_ExternalPrivlKeySize*/
        20,
        /*TST_output_data*/
        {0},
        /*TST_output_dataSize*/
        96,
        /*TST_Decrypted_data*/
        {0},
        /*TST_output_dataSize*/
        19,
	 }
};



